/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.api.AcceptRecommendation;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.api.XmlError;
import de.kosit.validationtool.impl.HtmlExtractor;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.s9api.XdmNode;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SchematronOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultResult
implements Result {
    private final XdmNode report;
    private CreateReportInput reportInput;
    private final AcceptRecommendation acceptRecommendation;
    private final HtmlExtractor htmlExtraction;
    private List<XmlError> schemaViolations;
    private List<SchematronOutput> schematronResult;
    private boolean processingSuccessful;
    private boolean wellformed;

    public DefaultResult(XdmNode report, AcceptRecommendation recommendation, HtmlExtractor htmlExtractor) {
        this.report = report;
        this.acceptRecommendation = recommendation;
        this.htmlExtraction = htmlExtractor;
    }

    @Override
    public List<String> getProcessingErrors() {
        return this.getReportInput().getProcessingError() != null ? this.getReportInput().getProcessingError().getError() : Collections.emptyList();
    }

    @Override
    public Document getReportDocument() {
        return (Document)((Object)NodeOverNodeInfo.wrap(this.getReport().getUnderlyingNode()));
    }

    @Override
    public boolean isAcceptable() {
        return this.isProcessingSuccessful() && AcceptRecommendation.ACCEPTABLE.equals((Object)this.acceptRecommendation);
    }

    @Override
    public boolean isSchemaValid() {
        return this.getSchemaViolations() != null && this.getSchemaViolations().isEmpty();
    }

    public List<String> extractHtmlAsString() {
        return this.htmlExtraction.extractAsString(this.getReport());
    }

    public List<XdmNode> extractHtml() {
        return this.htmlExtraction.extract(this.getReport());
    }

    public List<Element> extractHtmlAsElement() {
        return this.htmlExtraction.extractAsElement(this.getReport());
    }

    @Override
    public List<FailedAssert> getFailedAsserts() {
        return this.filterSchematronResult(FailedAssert.class);
    }

    private <T> List<T> filterSchematronResult(Class<T> type) {
        return this.getSchematronResult() != null ? this.getSchematronResult().stream().flatMap(e -> e.getActivePatternAndFiredRuleAndFailedAssert().stream()).filter(type::isInstance).map(type::cast).collect(Collectors.toList()) : Collections.emptyList();
    }

    private boolean isSchematronEvaluated() {
        return this.getSchematronResult() != null && this.getSchematronResult().stream().noneMatch(e -> e.getActivePatternAndFiredRuleAndFailedAssert().isEmpty());
    }

    @Override
    public boolean isSchematronValid() {
        return this.isSchematronEvaluated() && this.getFailedAsserts().isEmpty();
    }

    @Override
    @Generated
    public XdmNode getReport() {
        return this.report;
    }

    @Generated
    public CreateReportInput getReportInput() {
        return this.reportInput;
    }

    @Generated
    void setReportInput(CreateReportInput reportInput) {
        this.reportInput = reportInput;
    }

    @Override
    @Generated
    public AcceptRecommendation getAcceptRecommendation() {
        return this.acceptRecommendation;
    }

    @Generated
    void setSchemaViolations(List<XmlError> schemaViolations) {
        this.schemaViolations = schemaViolations;
    }

    @Override
    @Generated
    public List<XmlError> getSchemaViolations() {
        return this.schemaViolations;
    }

    @Override
    @Generated
    public List<SchematronOutput> getSchematronResult() {
        return this.schematronResult;
    }

    @Generated
    void setSchematronResult(List<SchematronOutput> schematronResult) {
        this.schematronResult = schematronResult;
    }

    @Override
    @Generated
    public boolean isProcessingSuccessful() {
        return this.processingSuccessful;
    }

    @Generated
    public void setProcessingSuccessful(boolean processingSuccessful) {
        this.processingSuccessful = processingSuccessful;
    }

    @Override
    @Generated
    public boolean isWellformed() {
        return this.wellformed;
    }

    @Generated
    public void setWellformed(boolean wellformed) {
        this.wellformed = wellformed;
    }
}

