/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.input;

import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.input.LazyReadInput;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.input.CountingInputStream;

public class StreamHelper {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private StreamHelper() {
    }

    public static MessageDigest createDigest(String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("Specified method %s is not available", algorithm), e);
        }
    }

    public static InputStream wrapCount(LazyReadInput input, InputStream stream) {
        return new CountInputStream(input, stream);
    }

    public static InputStream wrapDigesting(LazyReadInput input, InputStream stream, String digestAlgorithm) {
        return new DigestingInputStream(input, stream, StreamHelper.createDigest(digestAlgorithm));
    }

    public static BufferedInputStream wrapPeekable(InputStream stream) {
        return new PeekableInputStream(stream);
    }

    public static Input drain(Input input) throws IOException {
        StreamSource s = (StreamSource)input.getSource();
        try (InputStream stream = s.getInputStream();){
            StreamHelper.drain(stream);
        }
        return input;
    }

    public static void drain(InputStream input) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
        }
    }

    private static class CountInputStream
    extends FilterInputStream {
        private final LazyReadInput reference;

        public CountInputStream(LazyReadInput input, InputStream stream) {
            super(new CountingInputStream(stream));
            this.reference = input;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.reference.setLength(((CountingInputStream)this.in).getByteCount());
        }
    }

    private static class DigestingInputStream
    extends FilterInputStream {
        private final MessageDigest digest;
        private final LazyReadInput reference;

        DigestingInputStream(LazyReadInput input, InputStream in, MessageDigest digest) {
            super(new DigestInputStream(in, digest));
            this.digest = digest;
            this.reference = input;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.reference.setHashCode(this.digest.digest());
        }
    }

    private static class PeekableInputStream
    extends BufferedInputStream {
        public PeekableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public synchronized int available() throws IOException {
            int count = super.available();
            if (count == 0) {
                count = this.peek();
            }
            return count;
        }

        private int peek() throws IOException {
            try {
                this.mark(2);
                this.read();
                this.read();
                this.reset();
            }
            catch (IOException e) {
                return 0;
            }
            return super.available();
        }
    }
}

