/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import lombok.Generated;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.sapling.SaplingDocument;
import net.sf.saxon.sapling.Saplings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class CreateReportAction
implements CheckAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateReportAction.class);
    private static final String ERROR_MESSAGE_ELEMENT = "error-message";
    private final Processor processor;
    private final ConversionService conversionService;

    private static XsltExecutable loadFromScenario(Scenario object) {
        return object.getReportTransformation().getExecutable();
    }

    private static XsltExecutable getTransformation(CheckAction.Bag results) {
        return CreateReportAction.loadFromScenario(results.getScenarioSelectionResult().getObject());
    }

    @Override
    public void check(CheckAction.Bag results) {
        DocumentBuilder documentBuilder = this.processor.newDocumentBuilder();
        try {
            XdmNode parsedDocument = results.getParserResult().isValid() ? results.getParserResult().getObject() : this.createErrorInformation(results.getParserResult().getErrors());
            Marshaller marshaller = this.conversionService.getJaxbContext().createMarshaller();
            JAXBSource source = new JAXBSource(marshaller, (Object)results.getReportInput());
            source.setXMLReader((XMLReader)new ReaderWrapper(source.getXMLReader()));
            XdmNode root = documentBuilder.build((Source)source);
            XsltTransformer transformer = CreateReportAction.getTransformation(results).load();
            transformer.setInitialContextNode(root);
            CollectingErrorEventHandler e = new CollectingErrorEventHandler();
            transformer.setMessageListener(e);
            Scenario scenario = results.getScenarioSelectionResult().getObject();
            transformer.setURIResolver(scenario.getUriResolver());
            if (scenario.getUnparsedTextURIResolver() != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(scenario.getUnparsedTextURIResolver());
            }
            if (parsedDocument != null) {
                transformer.setParameter(new QName("input-document"), parsedDocument);
            }
            XdmDestination destination = new XdmDestination();
            transformer.setDestination(destination);
            transformer.transform();
            results.setReport(destination.getXdmNode());
        }
        catch (JAXBException | SaxonApiException e) {
            log.error("Error creating final report", e);
            results.stopProcessing("Can not create final report: " + e.getMessage());
        }
    }

    private XdmNode createErrorInformation(Collection<XMLSyntaxError> errors) throws SaxonApiException {
        String message = errors.stream().map(XMLSyntaxError::getMessage).collect(Collectors.joining());
        SaplingDocument doc = Saplings.doc(EngineInformation.getFrameworkNamespace());
        return doc.withChild(Saplings.elem(ERROR_MESSAGE_ELEMENT).withText(message)).toXdmNode(this.processor);
    }

    @Generated
    public CreateReportAction(Processor processor, ConversionService conversionService) {
        this.processor = processor;
        this.conversionService = conversionService;
    }

    private static class ReaderWrapper
    implements XMLReader {
        private static final String SAX_FEATURES_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
        private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
        private final XMLReader delegate;

        public ReaderWrapper(XMLReader xmlReader) {
            this.delegate = xmlReader;
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (SAX_FEATURES_NAMESPACES.equals(name)) {
                return true;
            }
            if (SAX_FEATURES_NAMESPACE_PREFIXES.equals(name)) {
                return false;
            }
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equals(SAX_FEATURES_NAMESPACES) && !value) {
                throw new SAXNotRecognizedException(name);
            }
            if (name.equals(SAX_FEATURES_NAMESPACE_PREFIXES) && value) {
                throw new SAXNotRecognizedException(name);
            }
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.delegate.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.delegate.setProperty(name, value);
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.delegate.getEntityResolver();
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.delegate.setEntityResolver(resolver);
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.delegate.getDTDHandler();
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.delegate.setDTDHandler(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.delegate.getContentHandler();
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.delegate.setContentHandler(handler);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.delegate.getErrorHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.delegate.setErrorHandler(handler);
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            this.delegate.parse(input);
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            this.delegate.parse(systemId);
        }
    }
}

