/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.CommandLineApplication;
import de.kosit.validationtool.cmd.ReturnValue;
import de.kosit.validationtool.cmd.TypeConverter;
import de.kosit.validationtool.cmd.Validator;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(description={"Structural and semantic validation of xml files"}, name="KoSIT Validator", mixinStandardHelpOptions=false, separator=" ", synopsisHeading="Usage: ")
public class CommandLineOptions
implements Callable<ReturnValue> {
    static final String SYNOSIS_HEADING = "Usage: ";
    @CommandLine.ArgGroup(exclusive=false, heading="Daemon options\n")
    private DaemonOptions daemonOptions;
    @CommandLine.ArgGroup(exclusive=false, heading="CLI usage options\n")
    private CliOptions cliOptions;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Prints some more debug information"})
    private boolean debugOutput;
    @CommandLine.Option(names={"-?", "--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-X", "--debug-logging"}, description={"Enables full debug log. Alias for -l debug"})
    private boolean debugLog;
    @CommandLine.Option(names={"-l", "--log-level"}, description={"Enables a certain log level for debugging purposes"}, defaultValue="OFF")
    private CommandLineApplication.Level logLevel;
    @CommandLine.Option(names={"-r", "--repository"}, paramLabel="repository-path", description={"Directory containing scenario content"}, converter={TypeConverter.RepositoryConverter.class})
    private List<RepositoryDefinition> repositories;
    @CommandLine.Option(names={"-s", "--scenarios"}, description={"Location of scenarios.xml"}, paramLabel="scenario.xml", required=true, converter={TypeConverter.ScenarioConverter.class})
    private List<ScenarioDefinition> scenarios;

    @Override
    public ReturnValue call() throws Exception {
        CommandLineOptions.configureLogging(this);
        return Validator.mainProgram(this);
    }

    private static void configureLogging(CommandLineOptions cmd) {
        if (cmd.isDebugLog()) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "DEBUG");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", cmd.getLogLevel().name());
        }
    }

    public boolean isDaemonModeEnabled() {
        return this.getDaemonOptions() != null;
    }

    public boolean isCliModeEnabled() {
        return this.getCliOptions() != null;
    }

    @Generated
    public DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    @Generated
    public CliOptions getCliOptions() {
        return this.cliOptions;
    }

    @Generated
    public boolean isDebugOutput() {
        return this.debugOutput;
    }

    @Generated
    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    @Generated
    public boolean isDebugLog() {
        return this.debugLog;
    }

    @Generated
    public CommandLineApplication.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public List<RepositoryDefinition> getRepositories() {
        return this.repositories;
    }

    @Generated
    public List<ScenarioDefinition> getScenarios() {
        return this.scenarios;
    }

    static class DaemonOptions {
        @CommandLine.Option(names={"-D", "--daemon"}, description={"Starts a daemon listing for validation requests"}, defaultValue="false", required=true)
        private boolean daemonMode;
        @CommandLine.Option(names={"-H", "--host"}, description={"The hostname / IP address to bind the daemon."}, defaultValue="localhost", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private String host;
        @CommandLine.Option(names={"-P", "--port"}, description={"The port to bind the daemon."}, defaultValue="8080", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private int port;
        @CommandLine.Option(names={"-T", "--threads"}, description={"Number of threads processing validation requests. Default depends on processor count"}, defaultValue="-1", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private int workerCount;
        @CommandLine.Option(names={"-G", "--disable-gui"}, description={"Disables the GUI of the daemon mode"})
        private boolean disableGUI;

        @Generated
        public boolean isDaemonMode() {
            return this.daemonMode;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public int getWorkerCount() {
            return this.workerCount;
        }

        @Generated
        public boolean isDisableGUI() {
            return this.disableGUI;
        }

        @Generated
        public DaemonOptions() {
        }
    }

    static class CliOptions {
        @CommandLine.Option(names={"-o", "--output-directory"}, description={"Defines the out directory for results."}, defaultValue=".", required=true)
        private Path outputPath;
        @CommandLine.Option(names={"-h", "--html", "--extract-html"}, description={"Extract and save any html content within result as a separate file"})
        private boolean extractHtml;
        @CommandLine.Option(names={"--serialize-report-input"}, description={"Serializes the report input to the cwd"}, defaultValue="false")
        private boolean serializeInput;
        @CommandLine.Option(names={"-c", "--check-assertions"}, paramLabel="assertions-file", description={"Check the result using defined assertions"})
        private Path assertions;
        @CommandLine.Option(names={"--report-postfix"}, description={"Postfix of the generated report name"})
        private String reportPostfix;
        @CommandLine.Option(names={"--report-prefix"}, description={"Prefix of the generated report name"})
        private String reportPrefix;
        @CommandLine.Option(names={"-m", "--memory-stats"}, description={"Prints some memory stats"})
        private boolean printMemoryStats;
        @CommandLine.Option(names={"-p", "--print"}, description={"Prints the check result to stdout"})
        private boolean printReport;
        @CommandLine.Parameters(arity="1..*", description={"Files to validate"})
        private List<Path> files;

        @Generated
        public Path getOutputPath() {
            return this.outputPath;
        }

        @Generated
        public boolean isExtractHtml() {
            return this.extractHtml;
        }

        @Generated
        public boolean isSerializeInput() {
            return this.serializeInput;
        }

        @Generated
        public Path getAssertions() {
            return this.assertions;
        }

        @Generated
        public String getReportPostfix() {
            return this.reportPostfix;
        }

        @Generated
        public String getReportPrefix() {
            return this.reportPrefix;
        }

        @Generated
        public boolean isPrintMemoryStats() {
            return this.printMemoryStats;
        }

        @Generated
        public boolean isPrintReport() {
            return this.printReport;
        }

        @Generated
        public List<Path> getFiles() {
            return this.files;
        }

        @Generated
        public CliOptions() {
        }
    }

    public static class ScenarioDefinition
    extends Definition {
    }

    public static class RepositoryDefinition
    extends Definition {
    }

    public static abstract class Definition {
        String name;
        Path path;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPath(Path path) {
            this.path = path;
        }
    }
}

