/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.api.AcceptRecommendation;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.util.Optional;
import lombok.Generated;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathSelector;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeAcceptanceAction
implements CheckAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeAcceptanceAction.class);

    @Override
    public void check(CheckAction.Bag results) {
        if (results.isStopped() && results.getParserResult().isValid()) {
            return;
        }
        if (ComputeAcceptanceAction.preCondtionsMatch(results)) {
            Optional<XPathSelector> acceptMatch = results.getScenarioSelectionResult().getObject().getAcceptSelector();
            if (results.getSchemaValidationResult().isValid() && acceptMatch.isPresent()) {
                ComputeAcceptanceAction.evaluateAcceptanceMatch(results, acceptMatch.get());
            } else {
                this.evaluateSchemaAndSchematron(results);
            }
        } else {
            results.setAcceptStatus(AcceptRecommendation.REJECT);
        }
    }

    private void evaluateSchemaAndSchematron(CheckAction.Bag results) {
        if (results.getSchemaValidationResult().isValid() && ComputeAcceptanceAction.isSchematronValid(results)) {
            results.setAcceptStatus(AcceptRecommendation.ACCEPTABLE);
        } else {
            results.setAcceptStatus(AcceptRecommendation.REJECT);
        }
    }

    private static boolean isSchematronValid(CheckAction.Bag results) {
        return !ComputeAcceptanceAction.hasSchematronErrors(results);
    }

    private static boolean hasSchematronErrors(CheckAction.Bag results) {
        return results.getReportInput().getValidationResultsSchematron().stream().map(e -> e.getResults().getSchematronOutput()).flatMap(e -> e.getActivePatternAndFiredRuleAndFailedAssert().stream()).anyMatch(FailedAssert.class::isInstance);
    }

    private static void evaluateAcceptanceMatch(CheckAction.Bag results, XPathSelector selector) {
        try {
            selector.setContextItem(results.getReport());
            results.setAcceptStatus(selector.effectiveBooleanValue() ? AcceptRecommendation.ACCEPTABLE : AcceptRecommendation.REJECT);
        }
        catch (SaxonApiException e) {
            String msg = String.format("Error evaluating accept recommendation: %s", selector.getUnderlyingXPathContext().toString());
            log.error(msg, e);
            results.stopProcessing(msg);
        }
    }

    private static boolean preCondtionsMatch(CheckAction.Bag results) {
        return results.getReport() != null && results.getSchemaValidationResult() != null && results.getScenarioSelectionResult() != null;
    }

    @Generated
    public ComputeAcceptanceAction() {
    }
}

